/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.entities;

import com.alexander.mutantmore.entities.MutantWitherSkeleton;
import com.alexander.mutantmore.enums.CameraShakePriority;
import com.alexander.mutantmore.events.ShakeCameraEvent;
import com.alexander.mutantmore.init.DamageSourceInit;
import com.alexander.mutantmore.init.EntityTypeInit;
import com.alexander.mutantmore.init.ParticleTypeInit;
import com.alexander.mutantmore.init.TagInit;
import com.alexander.mutantmore.util.HandleLoopingSoundInstances;
import com.alexander.mutantmore.util.MiscUtils;
import com.google.common.collect.Lists;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;
import software.bernie.geckolib3.util.GeckoLibUtil;

public class FireSlash
extends Projectile
implements IAnimatable {
    private AnimationFactory factory = GeckoLibUtil.createFactory((IAnimatable)this);
    public int textureChange = 0;
    public int lifeTime = 200;
    public float damage = 0.0f;
    public int fireLength = 0;
    public boolean griefing = true;
    public boolean ignoresInvulTime = true;
    public List<Entity> alreadyHit = Lists.newArrayList();

    public FireSlash(EntityType<? extends FireSlash> p_37027_, Level p_37028_) {
        super(p_37027_, p_37028_);
    }

    public FireSlash(Level p_37030_, double p_37031_, double p_37032_, double p_37033_) {
        super((EntityType)EntityTypeInit.FIRE_SLASH.get(), p_37030_);
        this.m_6034_(p_37031_, p_37032_, p_37033_);
        this.m_20256_(new Vec3(this.f_19796_.m_216328_(0.0, 0.002297), 0.05, this.f_19796_.m_216328_(0.0, 0.002297)).m_82490_(2.0));
    }

    public FireSlash(Level p_37036_, @Nullable Entity p_37037_, double p_37038_, double p_37039_, double p_37040_) {
        this(p_37036_, p_37038_, p_37039_, p_37040_);
        this.lifeTime = 200;
        this.m_5602_(p_37037_);
    }

    public FireSlash(Level p_37058_, LivingEntity p_37060_) {
        this(p_37058_, (Entity)p_37060_, p_37060_.m_20185_(), p_37060_.m_20186_(), p_37060_.m_20189_());
        this.lifeTime = 200;
    }

    public FireSlash(Level p_37043_, double p_37045_, double p_37046_, double p_37047_, boolean p_37048_) {
        this(p_37043_, p_37045_, p_37046_, p_37047_);
        this.lifeTime = 200;
    }

    public FireSlash(Level p_37050_, Entity p_37052_, double p_37053_, double p_37054_, double p_37055_, boolean p_37056_) {
        this(p_37050_, p_37053_, p_37054_, p_37055_, p_37056_);
        this.lifeTime = 200;
        this.m_5602_(p_37052_);
    }

    protected boolean m_5603_(Entity target) {
        return this.canHit(target) && super.m_5603_(target);
    }

    public void m_6686_(double p_37266_, double p_37267_, double p_37268_, float p_37269_, float p_37270_) {
        Vec3 vec3 = new Vec3(p_37266_, p_37267_, p_37268_).m_82541_().m_82520_(this.f_19796_.m_216328_(0.0, 0.0172275 * (double)p_37270_), this.f_19796_.m_216328_(0.0, 0.0172275 * (double)p_37270_), this.f_19796_.m_216328_(0.0, 0.0172275 * (double)p_37270_)).m_82490_((double)p_37269_);
        this.m_20256_(vec3.m_82490_(2.0));
        double d0 = vec3.m_165924_();
        this.m_146922_((float)(Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_) * 57.2957763671875));
        this.m_146926_((float)(Mth.m_14136_((double)vec3.f_82480_, (double)d0) * 57.2957763671875));
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (this.f_19853_.f_46443_) {
            HandleLoopingSoundInstances.addFireSlashAudio(this, this.f_19853_);
        }
    }

    public boolean m_6060_() {
        return false;
    }

    protected void m_8097_() {
    }

    public boolean m_6783_(double p_37065_) {
        return p_37065_ < 4096.0;
    }

    public void m_8119_() {
        HitResult hitresult;
        super.m_8119_();
        if (!this.f_19853_.f_46443_ && (hitresult = ProjectileUtil.m_37294_((Entity)this, this::m_5603_)).m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitresult)) {
            this.m_6532_(hitresult);
        }
        this.m_20101_();
        if (this.f_19853_.f_46443_) {
            ShakeCameraEvent.shake(this.f_19853_, 10, 0.0075f, this.m_20183_(), 5, CameraShakePriority.EFFECT);
        }
        for (int i = 0; i < 2; ++i) {
            double d0 = this.f_19796_.m_188583_() * 0.02;
            double d1 = this.f_19796_.m_188583_() * 0.02;
            double d2 = this.f_19796_.m_188583_() * 0.02;
            this.f_19853_.m_7107_((ParticleOptions)ParticleTypeInit.FIRE_TRAIL.get(), this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), d0, d1, d2);
        }
        if (this.f_19797_ % 5 == 0) {
            ++this.textureChange;
        }
        Vec3 vec33 = this.m_20184_();
        this.m_6478_(MoverType.SELF, vec33);
        this.m_20256_(vec33);
        HitResult hitresult2 = ProjectileUtil.m_37294_((Entity)this, this::m_5603_);
        this.m_6532_(hitresult2);
        this.f_19812_ = true;
        if (!this.f_19853_.f_46443_ && this.m_20071_()) {
            this.m_216990_(SoundEvents.f_11937_);
            this.m_146870_();
        }
        this.m_37283_();
        if (this.lifeTime > 0) {
            --this.lifeTime;
        }
        if (!this.f_19853_.f_46443_ && this.lifeTime <= 0) {
            this.m_146870_();
        }
    }

    protected void m_5790_(EntityHitResult p_37386_) {
        super.m_5790_(p_37386_);
        if (!this.f_19853_.f_46443_) {
            Entity entity = p_37386_.m_82443_();
            Entity entity1 = this.m_37282_();
            if (!this.alreadyHit.contains(entity) && this.canHarm(entity)) {
                if (this.ignoresInvulTime) {
                    entity.f_19802_ = 0;
                }
                boolean flag = entity.m_6469_(DamageSourceInit.fireSlashAttack((Entity)this, entity1), this.damage);
                int i = entity.m_20094_();
                entity.m_20254_(this.fireLength);
                if (!flag) {
                    entity.m_7311_(i);
                } else if (entity1 instanceof LivingEntity) {
                    this.alreadyHit.add(entity);
                    this.m_19970_((LivingEntity)entity1, entity);
                }
            }
        }
    }

    protected void m_8060_(BlockHitResult p_37384_) {
        super.m_8060_(p_37384_);
        if (!this.f_19853_.f_46443_) {
            Entity entity = this.m_37282_();
            BlockPos blockpos = p_37384_.m_82425_().m_121945_(p_37384_.m_82434_());
            if (this.f_19853_.m_46859_(blockpos) && this.griefing) {
                this.f_19853_.m_46597_(blockpos, BaseFireBlock.m_49245_((BlockGetter)this.f_19853_, (BlockPos)blockpos));
            }
            this.m_146870_();
        }
    }

    boolean canHarm(Entity target) {
        if (MiscUtils.canHarmBasedOnTeamAndTag(TagInit.EntityTypes.MUTANT_WITHER_SKELETON_FIRE_SLASH_CANT_HURT, (Entity)this, target, this.m_37282_(), entity -> entity instanceof MutantWitherSkeleton)) {
            return true;
        }
        if (MiscUtils.canHarmBasedOnTeamAndTag(TagInit.EntityTypes.PLAYER_FIRE_SLASH_CANT_HURT, (Entity)this, target, this.m_37282_(), entity -> entity instanceof Player)) {
            return true;
        }
        return MiscUtils.canHarmBasedOnTeamAndTag(null, (Entity)this, target, this.m_37282_(), entity -> !(entity instanceof MutantWitherSkeleton) && !(entity instanceof Player));
    }

    boolean canHit(Entity target) {
        if (MiscUtils.canHarmBasedOnTeamAndTag(TagInit.EntityTypes.MUTANT_WITHER_SKELETON_FIRE_SLASH_CANT_HIT, (Entity)this, target, this.m_37282_(), entity -> entity instanceof MutantWitherSkeleton)) {
            return true;
        }
        if (MiscUtils.canHarmBasedOnTeamAndTag(TagInit.EntityTypes.PLAYER_FIRE_SLASH_CANT_HIT, (Entity)this, target, this.m_37282_(), entity -> entity instanceof Player)) {
            return true;
        }
        return MiscUtils.canHarmBasedOnTeamAndTag(null, (Entity)this, target, this.m_37282_(), entity -> !(entity instanceof MutantWitherSkeleton) && !(entity instanceof Player));
    }

    protected void m_6532_(HitResult p_37388_) {
        super.m_6532_(p_37388_);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        this.damage = tag.m_128457_("Damage");
        this.fireLength = tag.m_128451_("FireLength");
        this.griefing = tag.m_128471_("Griefing");
        this.ignoresInvulTime = tag.m_128471_("IgnoresInvulTime");
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        tag.m_128350_("Damage", this.damage);
        tag.m_128405_("FireLength", this.fireLength);
        tag.m_128379_("Griefing", this.griefing);
        tag.m_128379_("IgnoresInvulTime", this.ignoresInvulTime);
    }

    public boolean m_6097_() {
        return false;
    }

    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

